package ch.frankel.blog.lombok;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;

import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Test class for class DelegateExample.
 * 
 * @author <a href="http://blog.frankel.ch">Nicolas Frankel</a>
 */
public class DelegateExampleTest {

    /** Class to test. */
    private static Class<?> clazz;

    /** Instance to test. */
    private static Object object;

    /**
     * Compiles the class to be tested.
     * 
     * @throws Exception
     */
    @BeforeClass
    public static void beforeClass() throws Exception {

        File file = new File("target/test-classes/ch/DelegateExample.class");

        if (file.exists()) {

            file.delete();
        }

        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

        StandardJavaFileManager sjfm = compiler.getStandardFileManager(null, null, null);

        Iterable<? extends JavaFileObject> jvos = sjfm.getJavaFileObjects(new File(
                "src/test/resources/ch/DelegateExample.java"));

        String[] options = new String[] { "-sourcepath", "src/test/java;src/main/java", "-d", "target/test-classes" };

        boolean success = compiler.getTask(null, sjfm, null, Arrays.asList(options), null, jvos).call();

        Assert.assertTrue("Failed Compilation", success);

        clazz = Class.forName("ch.DelegateExample");

        object = clazz.newInstance();
    }

    /**
     * Test a simple method with no argument.
     * 
     * @throws Exception
     */
    @Test
    public void testMethod1() throws Exception {

        clazz.getMethod("method1");
    }

    /**
     * Test simple getters method.
     * 
     * @throws Exception
     */
    @Test
    public void testMethod23() throws Exception {

        Method method2 = clazz.getMethod("method2");

        Assert.assertEquals(2, method2.invoke(object));

        Method method3 = clazz.getMethod("method3");

        Assert.assertTrue(method3.invoke(object) instanceof Date);
    }

    /**
     * Tests a parameter and return value for a method.
     * 
     * @throws Exception
     */
    @Test
    public void testSetInt() throws Exception {

        Method method = clazz.getMethod("set", int.class);

        Assert.assertEquals(5, method.invoke(object, 5));
    }

    /**
     * Tests whether an existing method is kept by the handler.
     * 
     * @throws Exception
     */
    @Test
    public void testDuplicateKept() throws Exception {

        Method method = clazz.getMethod("duplicate");

        Assert.assertEquals(1, method.invoke(object));
    }

    /**
     * Tests whether a new duplicating method is ignored by the handler.
     * 
     * @throws Exception
     */
    @Test(expected = NoSuchMethodException.class)
    public void testDuplicateNotWritten() throws Exception {

        clazz.getMethod("duplicate", int.class);
    }

    /**
     * Tests the delegation to a static method.
     * 
     * @throws Exception
     */
    @Test
    public void testStaticMethod() throws Exception {

        Method method = clazz.getMethod("staticMethod");

        Assert.assertEquals(10, method.invoke(object));
    }

    /**
     * Tests the creation of the throws clause.
     * 
     * @throws Exception
     */
    @Test
    public void testThrowException() throws Exception {

        Method method = clazz.getMethod("throwException");

        method.invoke(object);
    }
}
